/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.SQLiteDataTypeProvider;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteFunctionProvider;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\b\u0016\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\b\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\n\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\n\u0010\u0005J\u001b\u0010\u000e\u001a\u00020\r2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\r8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\r8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0011\u001a\u0004\b\u0015\u0010\u0013R\u001a\u0010\u0016\u001a\u00020\r8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0011\u001a\u0004\b\u0017\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/exposed/sql/vendors/SQLiteDialect;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "", "name", "createDatabase", "(Ljava/lang/String;)Ljava/lang/String;", "Lorg/jetbrains/exposed/sql/Index;", "index", "createIndex", "(Lorg/jetbrains/exposed/sql/Index;)Ljava/lang/String;", "dropDatabase", "Lorg/jetbrains/exposed/sql/Expression;", "e", "", "isAllowedAsColumnDefault", "(Lorg/jetbrains/exposed/sql/Expression;)Z", "supportsCreateSchema", "Z", "getSupportsCreateSchema", "()Z", "supportsCreateSequence", "getSupportsCreateSequence", "supportsMultipleGeneratedKeys", "getSupportsMultipleGeneratedKeys", "<init>", "()V", "Companion", "exposed-core"})
public class SQLiteDialect
extends VendorDialect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean supportsCreateSequence;
    private final boolean supportsMultipleGeneratedKeys;
    private final boolean supportsCreateSchema;
    @NotNull
    public static final String dialectName = "sqlite";
    @NotNull
    private static final Lazy<Boolean> ENABLE_UPDATE_DELETE_LIMIT$delegate = LazyKt.lazy((Function0)Companion.ENABLE_UPDATE_DELETE_LIMIT.2.INSTANCE);

    public SQLiteDialect() {
        super(dialectName, SQLiteDataTypeProvider.INSTANCE, SQLiteFunctionProvider.INSTANCE);
    }

    @Override
    public boolean getSupportsCreateSequence() {
        return this.supportsCreateSequence;
    }

    @Override
    public boolean getSupportsMultipleGeneratedKeys() {
        return this.supportsMultipleGeneratedKeys;
    }

    @Override
    public boolean getSupportsCreateSchema() {
        return this.supportsCreateSchema;
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        return true;
    }

    @Override
    @NotNull
    public String createIndex(@NotNull Index index) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        if (index.getIndexType() != null) {
            SQLLogKt.getExposedLogger().warn("Index of type " + index.getIndexType() + " on " + index.getTable().getTableName() + " for " + CollectionsKt.joinToString$default((Iterable)index.getColumns(), null, null, null, (int)0, null, (Function1)createIndex.1.INSTANCE, (int)31, null) + " can't be created in SQLite");
            return "";
        }
        String originalCreateIndex = super.createIndex(Index.copy$default(index, null, false, null, null, 13, null));
        return index.getUnique() ? StringsKt.replace$default((String)originalCreateIndex, (String)"CREATE INDEX", (String)"CREATE UNIQUE INDEX", (boolean)false, (int)4, null) : originalCreateIndex;
    }

    @Override
    @NotNull
    public String createDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        StringBuilder stringBuilder = new StringBuilder().append("ATTACH DATABASE '");
        String string = name.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        return stringBuilder.append(string).append(".db' AS ").append(DefaultKt.inProperCase(name)).toString();
    }

    @Override
    @NotNull
    public String dropDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return Intrinsics.stringPlus((String)"DETACH DATABASE ", (Object)DefaultKt.inProperCase(name));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u000b\u0010\fR\u001b\u0010\u0007\u001a\u00020\u00028FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\t\u001a\u00020\b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lorg/jetbrains/exposed/sql/vendors/SQLiteDialect$Companion;", "", "", "ENABLE_UPDATE_DELETE_LIMIT$delegate", "Lkotlin/Lazy;", "getENABLE_UPDATE_DELETE_LIMIT", "()Z", "ENABLE_UPDATE_DELETE_LIMIT", "", "dialectName", "Ljava/lang/String;", "<init>", "()V", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getENABLE_UPDATE_DELETE_LIMIT() {
            Lazy lazy2 = ENABLE_UPDATE_DELETE_LIMIT$delegate;
            return (Boolean)lazy2.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

